/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: HelperFunctions.h $
   Last Modification:
    $Author: MichaelT $
    $Modtime: $
    $Revision: 5407 $
   
   Targets:
     Win32/ANSI   : yes
     Win32/Unicode: yes (define _UNICODE)
     WinCE        : no
 
   Description:
    Definition of necessary download functions
       
   Changes:
 
     Version   Date        Author   Description
     ----------------------------------------------------------------------------------
     2         27.07.2010  SS       Redundant definitions removed
     1         09.07.2009  PL       created


**************************************************************************************/

#ifdef _DEBUG
  #define TRACE   odprintf
#else
  #define TRACE
#endif

#ifdef __cplusplus
  extern "C" {
#endif  /* _cplusplus */

#include "cifxuser.h"

// Forward declaration of data layer
class CDataLayer;

// Replace abstracted OS functions 
#define OS_Strnicmp   _strnicmp
#define OS_Strncpy    strncpy
#define OS_Strlen     strlen
#define OS_Memcpy     memcpy
#define OS_Memset     memset

  // Defines for the endian handling 
#define LE16_TO_HOST(a)   (a)
#define LE32_TO_HOST(a)   (a)
#define LE64_TO_HOST(a)   (a)
#define HOST_TO_LE16(a)   (a)
#define HOST_TO_LE32(a)   (a)
#define HOST_TO_LE64(a)   (a)

/*****************************************************************************/
/*! This function allows to send a printf-style formated message to the 
*   debugger. The odprintf() function formats the string, insures that there 
*   is a proper CR/LF at the end (removing any previous line terminations), 
*   and sends the message to the debugger.
*   \param format Printf-style formated message                              */
/*****************************************************************************/
void __cdecl odprintf(const char *format, ...);

/*****************************************************************************/
/*! Check if we have a NXF file
*   \param pszFileName      Input file name
*   \return 1 on success                                                     */
/*****************************************************************************/
int DEV_IsNXFFile( char* pszFileName);

/*****************************************************************************/
/*! Check if we have a NXO file
*   \param pszFileName      Input file name
*   \return 1 on success                                                     */
/*****************************************************************************/
int DEV_IsNXOFile( char* pszFileName);

/*****************************************************************************/
/*! Delete all existing files in a channel, from the file system. 
*   \param ptChannel          Channel instance
*   \param ulChannel          Channel number
*   \param pcDataLayer        Data layer
*   \param pfnRecvPacket      User callback for unsolicited receive packets
*   \param pvUser             User parameter passed on callback
*   \return CIFX_NO_ERROR on success                                         */
/*****************************************************************************/
int DEV_RemoveChannelFiles(void*                  pvChannel,
                           uint32_t               ulChannel,
                           CDataLayer*            pcDataLayer,
                           PFN_RECV_PKT_CALLBACK  pfnRecvPacket,
                           void*                  pvUser,
                           char*                  szExceptFile);


/*****************************************************************************/
/*! Delete the given file
*   \param pvChannel          Channel instance
*   \param ulChannelNumber    Channel number
*   \param pszFileName        Input file name
*   \param pcDataLayer        Data layer
*   \param pfnRecvPacket      User callback for unsolicited receive packets
*   \param pvUser             User parameter passed on callback
*   \return 1 on success                                                     */
/*****************************************************************************/
int32_t DEV_DeleteFile(void*                   pvChannel, 
                       uint32_t                ulChannelNumber, 
                       char*                   pszFileName,
                       CDataLayer*             pcDataLayer,
                       PFN_RECV_PKT_CALLBACK   pfnRecvPacket,
                       void*                   pvUser);

/*****************************************************************************/
/*! Get the firmware transfer type from file name
*   \param pszFileName      Input file name
*   \param pulTransferType  Buffer for transfer type
*   \return CIFX_NO_ERROR on success                                         */
/*****************************************************************************/
int32_t DEV_GetFWTransferTypeFromFileName( char*     pszFileName,
                                           uint32_t* pulTransferType);

/*****************************************************************************/
/*! Uploads a file from the hardware. It is required to list the files
* on the hardware, to know the file length for creating the buffer.
*   \param pvChannel          Channel instance the upload is performed on
*   \param ulChannel          Channel number the upload made is for
*   \param ulMailboxSize      Size of the mailbox
*   \param ulTransferType     Type of transfer (see RCX_FILE_XFER_XXX defines)
*   \param szFileName         Short file name
*   \param pulDataBufferLen   Length of the provided buffer, returned length of data
*   \param pvData             Buffer for storing upload. This buffer must be allocated by the caller.
*   \param pcDataLayer        Data layer
*   \param pfnCallback        User callback for upload progress indications
*   \param pfnRecvPktCallback User callback for unsolicited receive packets
*   \param pvUser             User parameter passed on callback
*   \return CIFX_NO_ERROR on success                                         */
/*****************************************************************************/
int32_t DEV_UploadFile(void*                   pvChannel,
                       uint32_t                ulChannel,
                       uint32_t                ulMailboxSize,
                       uint32_t                ulTransferType,
                       char*                   szFileName,
                       uint32_t*               pulDataBufferLen,
                       void*                   pvData,              
                       CDataLayer*             pcDataLayer,
                       PFN_PROGRESS_CALLBACK   pfnCallback,
                       PFN_RECV_PKT_CALLBACK   pfnRecvPktCallback,
                       void*                   pvUser);

/*****************************************************************************/
/*! Download a file to the hardware
*   \param pvChannel          Channel instance the download is performed on
*   \param ulChannel          Channel number the download is for
*   \param ulMailboxSize      Size of the mailbox
*   \param ulTransferType     Type of transfer (see RCX_FILE_XFER_XXX defines)
*   \param szFileName         Short file name (needed by firmware to create the file by name)
*   \param ulFileLength       Length of the file to download
*   \param pvData             File data being downloaded
*   \param pcDataLayer        Data layer
*   \param pfnCallback        User callback for download progress indications
*   \param pfnRecvPktCallback User callback for unsolicited receive packets
*   \param pvUser             User parameter passed on callback
*   \return CIFX_NO_ERROR on success                                         */
/*****************************************************************************/
int32_t DEV_DownloadFile(void*                 pvChannel,
                         uint32_t              ulChannel,
                         uint32_t              ulMailboxSize,
                         uint32_t              ulTransferType,
                         char*                 szFileName,
                         uint32_t              ulFileLength,
                         void*                 pvData,
                         CDataLayer*           pcDataLayer,
                         PFN_PROGRESS_CALLBACK pfnCallback,
                         PFN_RECV_PKT_CALLBACK pfnRecvPktCallback,
                         void*                 pvUser);

/*****************************************************************************/
/*! Exchanges a packet with the device
*   \param pvChannel        Channel instance to exchange a packet
*   \param ptSendPkt        Send packet pointer
*   \param ptRecvPkt        Pointer to place received Packet in
*   \param ulRecvBufferSize Length of the receive buffer
*   \param ulTimeout        Maximum time in ms to wait for an empty mailbox
*   \param pcDataLayer      Data layer
*   \param pvPktCallback    Packet callback for unhandled receive packets
*   \param pvUser           User data for callback function
*   \return CIFX_NO_ERROR on success                                         */
/*****************************************************************************/
int32_t DEV_TransferPacket( void*                  pvChannel,
                            CIFX_PACKET*           ptSendPkt, 
                            CIFX_PACKET*           ptRecvPkt,
                            uint32_t               ulRecvBufferSize,
                            uint32_t               ulTimeout,
                            CDataLayer*            pcDataLayer,
                            PFN_RECV_PKT_CALLBACK  pvPktCallback,
                            void*                  pvUser);

#ifdef __cplusplus
  }
#endif  /* _cplusplus */
